/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core;

import com.aptana.ruby.debug.core.IRubyBreakpoint;
import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.IRubyMethodBreakpoint;
import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.debug.core.RubyDebugModel;
import com.aptana.ruby.debug.core.model.IEvaluationResult;
import com.aptana.ruby.debug.core.model.IRubyExceptionBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import com.aptana.ruby.internal.debug.core.ClassicDebuggerCommandFactory;
import com.aptana.ruby.internal.debug.core.DebuggerNotFoundException;
import com.aptana.ruby.internal.debug.core.ExceptionSuspensionPoint;
import com.aptana.ruby.internal.debug.core.ICommandFactory;
import com.aptana.ruby.internal.debug.core.RubyDebugCommandFactory;
import com.aptana.ruby.internal.debug.core.SuspensionPoint;
import com.aptana.ruby.internal.debug.core.commands.AbstractDebuggerConnection;
import com.aptana.ruby.internal.debug.core.commands.BreakpointCommand;
import com.aptana.ruby.internal.debug.core.commands.BreakpointConditionSetCommand;
import com.aptana.ruby.internal.debug.core.commands.ClassicDebuggerConnection;
import com.aptana.ruby.internal.debug.core.commands.ExceptionBreakpointCommand;
import com.aptana.ruby.internal.debug.core.commands.GenericCommand;
import com.aptana.ruby.internal.debug.core.commands.RubyDebugConnection;
import com.aptana.ruby.internal.debug.core.model.IRubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyEvaluationResult;
import com.aptana.ruby.internal.debug.core.model.RubyProcessingException;
import com.aptana.ruby.internal.debug.core.model.RubyStackFrame;
import com.aptana.ruby.internal.debug.core.model.RubyThread;
import com.aptana.ruby.internal.debug.core.model.RubyVariable;
import com.aptana.ruby.internal.debug.core.model.ThreadInfo;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.ErrorReader;
import com.aptana.ruby.internal.debug.core.parsing.FramesReader;
import com.aptana.ruby.internal.debug.core.parsing.LoadResultReader;
import com.aptana.ruby.internal.debug.core.parsing.SuspensionReader;
import com.aptana.ruby.internal.debug.core.parsing.ThreadInfoReader;
import com.aptana.ruby.internal.debug.core.parsing.VariableReader;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

public class RubyDebuggerProxy {
    public static final String DEBUGGER_ACTIVE_KEY = "com.aptana.ruby.debug.ui.debuggerActive";
    private AbstractDebuggerConnection debuggerConnection;
    private IRubyDebugTarget debugTarget;
    private RubyLoop rubyLoop;
    private ICommandFactory commandFactory;
    private Thread threadUpdater;
    private Thread errorReader;

    public RubyDebuggerProxy(IRubyDebugTarget debugTarget, boolean isRubyDebug) {
        this.debugTarget = debugTarget;
        debugTarget.setRubyDebuggerProxy(this);
        this.commandFactory = isRubyDebug ? new RubyDebugCommandFactory() : new ClassicDebuggerCommandFactory();
        this.debuggerConnection = isRubyDebug ? new RubyDebugConnection(debugTarget.getHost(), debugTarget.getPort()) : new ClassicDebuggerConnection(debugTarget.getPort());
    }

    public boolean checkConnection() {
        return this.debuggerConnection.isCommandPortConnected();
    }

    public void start() throws RubyProcessingException, IOException {
        this.debuggerConnection.connect();
        this.setBreakPoints();
        this.startRubyLoop();
    }

    public void stop() throws IOException {
        if (this.rubyLoop == null) {
            return;
        }
        this.rubyLoop.setShouldStop();
        this.rubyLoop.interrupt();
        this.closeConnection();
    }

    protected void setBreakPoints() throws IOException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(RubyDebugModel.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            this.addBreakpoint(breakpoints[i]);
            ++i;
        }
    }

    public void addBreakpoint(IBreakpoint breakpoint) {
        try {
            if (breakpoint.isEnabled()) {
                if (breakpoint instanceof IRubyExceptionBreakpoint) {
                    String command = this.commandFactory.createCatchOn((IRubyExceptionBreakpoint)breakpoint);
                    new ExceptionBreakpointCommand(command).executeWithResult(this.debuggerConnection);
                } else if (breakpoint instanceof IRubyMethodBreakpoint) {
                    IRubyMethodBreakpoint rubymethodBreakpoint = (IRubyMethodBreakpoint)breakpoint;
                    String command = this.commandFactory.createAddMethodBreakpoint(rubymethodBreakpoint.getFilePath().toOSString(), rubymethodBreakpoint.getTypeName(), rubymethodBreakpoint.getMethodName(), rubymethodBreakpoint.getLineNumber());
                    int index = new BreakpointCommand(command).executeWithResult(this.debuggerConnection);
                    rubymethodBreakpoint.setIndex(index);
                } else if (breakpoint instanceof IRubyLineBreakpoint) {
                    IRubyLineBreakpoint rubyLineBreakpoint = (IRubyLineBreakpoint)breakpoint;
                    String command = this.commandFactory.createAddBreakpoint(rubyLineBreakpoint.getLocation().toOSString(), rubyLineBreakpoint.getLineNumber());
                    int index = new BreakpointCommand(command).executeWithResult(this.debuggerConnection);
                    rubyLineBreakpoint.setIndex(index);
                    if (rubyLineBreakpoint.isConditionEnabled()) {
                        command = this.commandFactory.createSetCondition(rubyLineBreakpoint);
                        new BreakpointConditionSetCommand(command).execute(this.debuggerConnection);
                    }
                }
            }
        }
        catch (IOException e) {
            RubyDebugCorePlugin.log(e);
        }
        catch (CoreException e) {
            RubyDebugCorePlugin.log(e);
        }
    }

    public void removeBreakpoint(IBreakpoint breakpoint) {
        try {
            IRubyLineBreakpoint rubyLineBreakpoint;
            if (breakpoint instanceof IRubyExceptionBreakpoint) {
                String command = this.commandFactory.createCatchOff((IRubyExceptionBreakpoint)breakpoint);
                if (command != null) {
                    new BreakpointCommand(command).execute(this.debuggerConnection);
                }
            } else if (breakpoint instanceof IRubyLineBreakpoint && (rubyLineBreakpoint = (IRubyLineBreakpoint)breakpoint).getIndex() != -1) {
                String command = this.commandFactory.createRemoveBreakpoint(rubyLineBreakpoint.getIndex());
                new BreakpointCommand(command).executeWithResult(this.debuggerConnection);
                rubyLineBreakpoint.setIndex(-1);
            }
        }
        catch (IOException e) {
            RubyDebugCorePlugin.log(e);
        }
        catch (CoreException e) {
            RubyDebugCorePlugin.log(e);
        }
    }

    public void updateBreakpoint(IBreakpoint breakpoint, IMarkerDelta markerDelta) {
        this.removeBreakpoint(breakpoint);
        this.addBreakpoint(breakpoint);
    }

    public void startRubyLoop() throws DebuggerNotFoundException, IOException {
        this.debuggerConnection.start();
        this.rubyLoop = new RubyLoop();
        this.rubyLoop.start();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        RubyDebugCorePlugin.debug("Command Connection error handler started.");
                        while (RubyDebuggerProxy.this.debuggerConnection.getCommandReadStrategy().isConnected()) {
                            new ErrorReader(RubyDebuggerProxy.this.debuggerConnection.getCommandReadStrategy()).read();
                        }
                    }
                    catch (Exception e) {
                        RubyDebugCorePlugin.log(e);
                        RubyDebugCorePlugin.debug("Command Connection error handler finished.");
                    }
                }
                finally {
                    RubyDebugCorePlugin.debug("Command Connection error handler finished.");
                }
            }
        };
        this.errorReader = new Thread(runnable, "Error Reader");
        this.errorReader.start();
        Runnable threadListener = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        RubyDebugCorePlugin.debug("Thread updater started.");
                        Thread.sleep(2000L);
                        GenericCommand cmd = null;
                        while (cmd == null || cmd.getReadStrategy().isConnected()) {
                            if (!RubyDebuggerProxy.this.getDebugTarget().isSuspended()) {
                                String command = RubyDebuggerProxy.this.commandFactory.createReadThreads();
                                cmd = new GenericCommand(command, true);
                                cmd.execute(RubyDebuggerProxy.this.debuggerConnection);
                                ThreadInfo[] threadInfos = new ThreadInfoReader(cmd.getReadStrategy()).readThreads();
                                ((RubyDebugTarget)RubyDebuggerProxy.this.getDebugTarget()).updateThreads(threadInfos);
                            }
                            Thread.sleep(2000L);
                        }
                    }
                    catch (Exception e) {
                        RubyDebugCorePlugin.log(e);
                        RubyDebugCorePlugin.debug("Thread updater finished.");
                    }
                }
                finally {
                    RubyDebugCorePlugin.debug("Thread updater finished.");
                }
            }
        };
        this.threadUpdater = new Thread(threadListener, "Ruby Thread Updater");
        this.threadUpdater.start();
    }

    public void resume(RubyThread thread) {
        try {
            this.println(this.commandFactory.createResume(thread));
        }
        catch (IOException iOException) {}
    }

    protected void println(String s) throws IOException {
        try {
            new GenericCommand(s, false).execute(this.debuggerConnection);
        }
        catch (IOException e) {
            RubyDebugCorePlugin.debug("Could not send to debugger. Exception occured.", e);
            throw e;
        }
    }

    protected IRubyDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public RubyVariable[] readVariables(RubyStackFrame frame) throws DebugException {
        try {
            this.println(this.commandFactory.createReadLocalVariables(frame));
            return new VariableReader(this.getMultiReaderStrategy()).readVariables(frame);
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, RubyDebugCorePlugin.getPluginIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
    }

    public RubyVariable[] readInstanceVariables(RubyVariable variable) {
        try {
            this.println(this.commandFactory.createReadInstanceVariable(variable));
            return new VariableReader(this.getMultiReaderStrategy()).readVariables(variable);
        }
        catch (Exception ioex) {
            ioex.printStackTrace();
            throw new RuntimeException(ioex.getMessage());
        }
    }

    public RubyVariable readInspectExpression(IRubyStackFrame frame, String expression) throws RubyProcessingException {
        RubyVariable[] variables;
        RubyEvaluationResult result;
        block3: {
            try {
                expression = expression.replaceAll("\\n", "\\\\n");
                result = new RubyEvaluationResult(expression, frame.getThread());
                this.println(this.commandFactory.createInspect(frame, expression));
                variables = new VariableReader(this.getMultiReaderStrategy()).readVariables(frame);
                if (variables.length != 0) break block3;
                return null;
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                throw new RuntimeException(ioex.getMessage());
            }
        }
        result.setValue(variables[0].getValue());
        return variables[0];
    }

    public IEvaluationResult evaluate(RubyStackFrame frame, String expression) {
        expression = expression.replaceAll("\\r\\n", "\n");
        expression = expression.replaceAll("\\n", "; ");
        expression = expression.trim();
        RubyEvaluationResult result = new RubyEvaluationResult(expression, frame.getThread());
        try {
            this.println(this.commandFactory.createInspect(frame, expression));
            RubyVariable[] variables = new VariableReader(this.getMultiReaderStrategy()).readVariables(frame);
            if (variables.length > 0) {
                result.setValue(variables[0].getValue());
            }
        }
        catch (IOException ioex) {
            DebugException ex = new DebugException((IStatus)new Status(4, "com.aptana.ruby.debug.core", 5013, ioex.getMessage(), (Throwable)ioex));
            result.setException(ex);
        }
        catch (RubyProcessingException e) {
            DebugException ex = new DebugException((IStatus)new Status(4, "com.aptana.ruby.debug.core", 5010, e.getMessage(), (Throwable)e));
            result.setException(ex);
        }
        return result;
    }

    public void sendStepOverEnd(RubyStackFrame stackFrame) {
        try {
            this.println(this.commandFactory.createStepOver(stackFrame));
        }
        catch (Exception e) {
            RubyDebugCorePlugin.log(e);
        }
    }

    public void sendStepReturnEnd(RubyStackFrame stackFrame) {
        try {
            this.println(this.commandFactory.createStepReturn(stackFrame));
        }
        catch (Exception e) {
            RubyDebugCorePlugin.log(e);
        }
    }

    public void sendStepIntoEnd(RubyStackFrame stackFrame) {
        try {
            this.println(this.commandFactory.createStepInto(stackFrame));
        }
        catch (Exception e) {
            RubyDebugCorePlugin.log(e);
        }
    }

    public void sendThreadStop(RubyThread thread) {
        try {
            String command = this.commandFactory.createThreadStop(thread);
            new GenericCommand(command, true).execute(this.debuggerConnection);
        }
        catch (Exception e) {
            RubyDebugCorePlugin.log(e);
        }
    }

    public RubyStackFrame[] readFrames(RubyThread thread) {
        try {
            this.println(this.commandFactory.createReadFrames(thread));
            return new FramesReader(this.getMultiReaderStrategy()).readFrames(thread);
        }
        catch (IOException e) {
            RubyDebugCorePlugin.log(e);
            return null;
        }
    }

    public ThreadInfo[] readThreads() {
        try {
            String command = this.commandFactory.createReadThreads();
            new GenericCommand(command, true).execute(this.debuggerConnection);
            return new ThreadInfoReader(this.getMultiReaderStrategy()).readThreads();
        }
        catch (Exception e) {
            RubyDebugCorePlugin.log(e);
            return null;
        }
    }

    public IStatus readLoadResult(String filename) {
        try {
            this.println(this.commandFactory.createLoad(filename));
            return new LoadResultReader(this.getMultiReaderStrategy()).readLoadResult();
        }
        catch (Exception e) {
            return new Status(4, RubyDebugCorePlugin.getPluginIdentifier(), -1, e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection() throws IOException {
        this.debuggerConnection.exit();
    }

    private AbstractReadStrategy getMultiReaderStrategy() {
        return this.debuggerConnection.getCommandReadStrategy();
    }

    public IRubyBreakpoint getBreakpoint(SuspensionPoint hit) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(RubyDebugModel.getModelIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (hit.isBreakpoint() && breakpoint instanceof IRubyLineBreakpoint) {
                try {
                    IRubyLineBreakpoint lineBreak = (IRubyLineBreakpoint)breakpoint;
                    if (lineBreak.getLineNumber() == hit.getLine() && lineBreak.getLocation().toOSString().equals(hit.getFile())) {
                        return lineBreak;
                    }
                }
                catch (CoreException e) {
                    RubyDebugCorePlugin.log(e);
                }
            } else if (hit.isException() && breakpoint instanceof IRubyExceptionBreakpoint) {
                try {
                    IRubyExceptionBreakpoint exception = (IRubyExceptionBreakpoint)breakpoint;
                    if (exception.getTypeName().equals(((ExceptionSuspensionPoint)hit).getExceptionType())) {
                        return exception;
                    }
                }
                catch (CoreException e) {
                    RubyDebugCorePlugin.log(e);
                }
            }
            ++n2;
        }
        return null;
    }

    class RubyLoop
    extends Thread {
        public RubyLoop() {
            this.setName("RubyDebuggerLoop");
        }

        public void setShouldStop() {
        }

        @Override
        public void run() {
            HashMap<IRubyBreakpoint, Integer> map = new HashMap<IRubyBreakpoint, Integer>(3);
            try {
                try {
                    SuspensionPoint hit;
                    System.setProperty(RubyDebuggerProxy.DEBUGGER_ACTIVE_KEY, "true");
                    RubyDebugCorePlugin.debug("Waiting for breakpoints.");
                    while ((hit = new SuspensionReader(RubyDebuggerProxy.this.getMultiReaderStrategy()).readSuspension()) != null) {
                        int hitCount;
                        IRubyBreakpoint breakpoint;
                        if (!hit.isStep() && (breakpoint = RubyDebuggerProxy.this.getBreakpoint(hit)) != null && (hitCount = breakpoint.getHitCount()) != -1) {
                            int count = 0;
                            if (map.containsKey(breakpoint)) {
                                count = (Integer)map.get(breakpoint);
                            }
                            if (++count != hitCount) {
                                map.put(breakpoint, count);
                                RubyDebuggerProxy.this.resume(((RubyDebugTarget)RubyDebuggerProxy.this.getDebugTarget()).getThreadById(hit.getThreadId()));
                                continue;
                            }
                            RubyDebuggerProxy.this.removeBreakpoint(breakpoint);
                            map.remove(breakpoint);
                        }
                        RubyDebugCorePlugin.debug(hit);
                        new Thread("RubyDebuggerProxy suspension notifier"){

                            @Override
                            public void run() {
                                RubyDebuggerProxy.this.getDebugTarget().suspensionOccurred(hit);
                            }
                        }.start();
                    }
                }
                catch (DebuggerNotFoundException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    RubyDebugCorePlugin.debug("Exception in socket reader loop.", ex);
                    if (map != null) {
                        map.clear();
                    }
                    map = null;
                    System.setProperty(RubyDebuggerProxy.DEBUGGER_ACTIVE_KEY, "false");
                    try {
                        RubyDebuggerProxy.this.getDebugTarget().terminate();
                        RubyDebuggerProxy.this.closeConnection();
                    }
                    catch (Exception e) {
                        RubyDebugCorePlugin.log(e);
                    }
                    RubyDebugCorePlugin.debug("Socket reader loop finished.");
                }
            }
            finally {
                if (map != null) {
                    map.clear();
                }
                map = null;
                System.setProperty(RubyDebuggerProxy.DEBUGGER_ACTIVE_KEY, "false");
                try {
                    RubyDebuggerProxy.this.getDebugTarget().terminate();
                    RubyDebuggerProxy.this.closeConnection();
                }
                catch (Exception e) {
                    RubyDebugCorePlugin.log(e);
                }
                RubyDebugCorePlugin.debug("Socket reader loop finished.");
            }
        }
    }
}

